///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "C:\\PROGRAMME\\GSTUDIO\\template";	// Path to WDL templates subdirectory

path "PanelPic";

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons

///////////////// Hier meine Defs
include <GA_Interface.wdl>;         
include <MessageBox.wdl>;
include <ActionFile.wdl>;          // here you find and define the objects you want to modify
include <Fitness.wdl>;             // here you can modify the fitness function


////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 8;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// Strings and filenames
// change this string to your own starting mission message.
string mission_str = "Fight your way through the level. Press [F1] for help";
string level_str = <Evolution9.WMB>; // give file names in angular brackets

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.pcx>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}


/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = ON;	// map entities share their textures

// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = ON;
// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
    wait(5);
  	splashscreen.visible = OFF;
	  bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	  //load_status();

// display the initial message
	// msg_show(mission_str,10);


// use the new 3rd person camera
	  move_view_cap = 1;

// un-freeze the game
	freeze_mode = 0;


randomize();
evolution_handle = dll_open("evolution9.dll");    // opens dll
WDL_syntax(0);            // retrieves WDL syntax
InterfaceInit(0);         // initializes the interface


init_EvolutionNo9(0);
init_population(0);

MyFitness(0);
}


/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
window WINSTART
{
	title			"3D GameStudio";
	size			480,320;
	mode			IMAGE;	//STANDARD;
	bg_color		RGB(240,240,240);
	frame			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	button		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}
