#include <fstream>
#include <iostream>
#include <istream>
#include <iomanip>
#include <vector>

using namespace std;

#pragma pack(1)

typedef float vec3[3];


///////////////////////////// Genetix
class koordinaten;
typedef std::vector<koordinaten> KOORD_VECTOR;
int koord_sorter;


class koordinaten
{
public:

	int x;
    int y;
	int z;
	int pan;
	int tilt;
	int roll;
	int id;
	koordinaten() : x(0), y(0), z(0), pan(0), tilt(0), roll(0), id(0) {};
	koordinaten(int NewX, int NewY, int NewZ, int NewPan, int NewTilt, int NewRoll, int NewId) : x(NewX), y(NewY), z(NewZ), pan(NewPan), tilt(NewTilt), roll(NewRoll), id(NewId) {};
};



				
//////////////////////////////////////////////////////////////////////////////////

int Zufallszahl(int n)                // erzeugt eine Zufallszah
{
    return rand() % n ;
}



typedef struct 
	{
	char	version[4];				// "MDL3" oder "MDL4"
	long	final;					// noch unbenutzt
	vec3	scale;					// 3d position Skalierungsfaktor
	vec3	offset;					// 3d Positions-Offset
	float	pad;					// unbenutzt
	vec3	eye;					// unbenutzt
	long	numskins;				// Zahl der Skin Texturen
	long	skinwidth;				// Breite der Textur
	long	skinheight;				// Hhe
	long	numverts;				// Anzahl Vertices
	long	numtris;				// Anzahl Dreiecke
	long	numframes;				// Anzahl Frames
	long	numskinverts;			// Anzahl 2d-Skin-Vertices
	long	flags;					// 0 = normal, 1 = terrain model
	long	numbones;				// Anzahl Bones
} mdl_header;


typedef unsigned char byte;

typedef struct 
{
	int		skintype;				// 0 fr 8bit (bpp ==1 ); 2 fr 565 RGB; 3 fr 444 ARGB (bpp = 2)
	byte	*skin;                  // skinbreite * skinhhe
} mdl_skin_t;


typedef struct
{
	short	u;			// Position horizontal, zwischen 0 und Skinbreite-1
	short v;			// Position vertikal, zwischen 0 und Skinhhe - 1
} mdl_uvvert_t;


typedef struct 
{
short index_xyz[3];		// Index von 3 3d vertices im Bereich 0 bis numverts
short index_unv[3];		// Index von 3 skin vertices im Bereich 0 bis numskinverts
} mdl_triangle_t;



typedef struct
{
byte				rawposition[3];			// XYZ Koordinate - Reichweite 256
byte				lightnormalindex;		// Index der vertex-Normale;
} mdl_trivertxb_t;


typedef struct		
{
unsigned short		rawposition[3];			// XYZ Koordinate, zwischen 0 - 65000
byte				lightnormalindex;		// Index der vertex-Normalen
byte				boneindex;				// Index des Boneindex)
} mdl_trivertxs_t;

typedef struct
{
} *mdl_trivertx_t;

typedef struct
{
long				type; // 0 fr byte-gapckte Positionen, 2 fr word-gepackte Positionen
mdl_trivertx_t		bboxmin, bboxmax;
char name[16];
mdl_trivertxb_t		*B_vertex;	
mdl_trivertxs_t		*S_vertex;
} mdl_frame_t;


/////////////////////////

class gst_mod 
{
public:
	gst_mod();
	~gst_mod();
	ReadData(char * filename);

	WritePictureData(char *filename);
	ModifyPictureData(char *filename);



	int pixel_ARGB;  // die Datei in Bytes
	int pixel;

	mdl_header		 MDL_Header;
	mdl_skin_t		 MDL_Skin;
	mdl_uvvert_t    *MDL_Skinverts;
	mdl_triangle_t	*MDL_Triangles;
	mdl_frame_t		*MDL_Frame;

} Modeller;


gst_mod::gst_mod()
{
}

gst_mod::~gst_mod()
{
}

//////////////////

gst_mod::ReadData(char * filename)
{
ifstream input(filename, ios::in | ios::binary);

/////////// Einlesen des Headers //////////
input.read( (char *) (&MDL_Header), sizeof( mdl_header ) );
///////////////////////////////////////////
cout << "Position nach dem Header ist "  << input.tellg();

/////////////// Einlesen Skinstruktur

input.read( (char *) (&MDL_Skin.skintype), sizeof(int) );


//////////////// Jetzt klren, wie gro das Bild ist
pixel = MDL_Header.skinheight * MDL_Header.skinwidth;
int alpha = int(MDL_Header.skinheight * MDL_Header.skinwidth * MDL_Skin.skintype); 

cout << "Bildgroesse mal bbp ist  " << alpha << " Pixel\n";

cout << "\nPosition vor dem 1. Pixel ist "  << input.tellg() << "\n";

MDL_Skin.skin = new byte[alpha];


pixel_ARGB = alpha;  // 16 bit Auflsung

for (int i = 0; i < alpha; i ++)
	{
	input.read( (char *) (&MDL_Skin.skin[i]), sizeof(byte) );
	}
/////////////////
cout << input.tellg();

int beta = int(MDL_Header.numskinverts);

MDL_Skinverts = new mdl_uvvert_t[alpha];

for (int j = 0; j < beta; j ++)
	{
	input.read( (char *) (&MDL_Skinverts[j]), sizeof(mdl_uvvert_t) );
	}

//input.read( (char *) (&MDL_Skinverts[j]), sizeof(mdl_uvvert_t) );

// cout << "u - Wert ist  " << MDL_Skinverts[12].v << "\n"; // scheint zu funktionieren


////////////////// Jetzt die Dreiecke /////////////////////////////
int gamma = int(MDL_Header.numtris);
MDL_Triangles = new mdl_triangle_t[gamma];

for (int k = 0; k < gamma; k ++)
	{
	input.read( (char *) (&MDL_Triangles[k]), sizeof(mdl_triangle_t) );
	}



////////////////////////////////////


///////////////////////////////// F R A M E S ////////////////////////////

int delta = int(MDL_Header.numframes);
MDL_Frame = new mdl_frame_t[delta];

cout << "Anzahl der Frames   " << delta;
for (int l = 0; l < delta; l ++)
	{
	input.read( (char *) (&MDL_Frame[l].type), sizeof(long) );

	if (MDL_Frame[l].type == 0)
		{
		input.read( (char *) (&MDL_Frame[l].bboxmin), sizeof(mdl_trivertxb_t) );
		}
	else input.read( (char *) (&MDL_Frame[l].bboxmin), sizeof(mdl_trivertxs_t) );

	if (MDL_Frame[l].type == 0)
		{
		input.read( (char *) (&MDL_Frame[l].bboxmax), sizeof(mdl_trivertxb_t) );
		}
	else input.read( (char *) (&MDL_Frame[l].bboxmax), sizeof(mdl_trivertxs_t) );

	input.read( (char *) (&MDL_Frame[l].name), sizeof( char[16]) );

	cout << "Name des Frames lautet " << MDL_Frame[l].name;

	int epsilon = MDL_Header.numverts;

	if (MDL_Frame[l].type == 0)
		{
		MDL_Frame[l].B_vertex = new mdl_trivertxb_t[epsilon];
		}
	else MDL_Frame[l].S_vertex = new mdl_trivertxs_t[epsilon];

	if (MDL_Frame[l].type == 0)
		{
			for (int m = 0; m < epsilon; m++)
			{
			input.read( (char *) (&MDL_Frame[l].B_vertex[m]), sizeof( mdl_trivertxb_t) );
			}
		}
	else	{
			for (int n = 0; n < epsilon; n++)
				{
				input.read( (char *) (&MDL_Frame[l].S_vertex[n]), sizeof( mdl_trivertxs_t) );
				}
			}
	}
	
cout << "Gleich End of File        " << input.tellg();
cout << "Ende der Datei ist        " << input.tellg();
}


////////////////////////////////////////

gst_mod::WritePictureData(char *filename)
{
	ofstream output(filename, ios::in | ios::binary );

if (output.good() )
	{
	cout << "Datei kann geschrieben werden";
	output.seekp(88);
	cout << "befinde mich jetzt an Pos  " << output.tellp();
	int alpha = 10;
	int red = 255;
	int green = 76;
	int blue = 200;
	output.write( (char *) (&alpha), sizeof(byte) ); 
	output.write( (char *) (&red), sizeof(byte) ); 
	output.write( (char *) (&green), sizeof(byte) ); 
	output.write( (char *) (&blue), sizeof(byte) ); 
	}
}


//////////////////////////////////
gst_mod::ModifyPictureData(char *filename)
{
ReadData(filename);
ofstream output(filename, ios::in | ios::binary );
if (output.good() )
	{
	output.seekp(88);        // gehe an die Position

	int a = 60;
	int b;
	byte nova;

	for (int i = 0; i < pixel_ARGB; i++)
		{
		a = Zufallszahl(a)- 30;
		b = int(MDL_Skin.skin[i]);
		b += a;
		nova = byte(a);
		output.write( (char *) (&nova), sizeof(byte) ); 
		}
	}
}

////////////////
////////////////////////////////////////////////////////////




////////////////////////////////////////////////////////

int main()
{
cout << "Das ist der Gamestudio Modeller";
return 0;
}



//////////////////////////////////////////////
