#include <fstream>
#include <iostream>
#include <istream>
#include <iomanip>
using namespace std;

#pragma pack(1);




#ifndef word
typedef unsigned short word;
#endif 

#ifndef byte;
typedef unsigned char byte;
#endif 

using namespace std;
///////////////////////////////////////////////////////////////////////////////////
//////////// This is free for anybody to whom it concerns  ////////////////////////
/////////// it would be nice if you mentioned my name, but it's not necessary
/////////// ameliorations are welcome
/////////// please mail to mb@superfluxus.de


typedef long fixed;	// fixed point 22.10 number format used by WDL

//////////////////////////// Milkshape Class ////////////////////



/////////////////////// These are struct defs of Mete Ciragan

typedef struct
{
char id[10];
int version;
} ms3d_header_t;


typedef struct
{
	byte flags;
	float vertex[3];
	char boneID;
	byte referenceCount;
}ms3d_vertex_t;



word nNumVertices;
word nNumTriangles;
word nNumGroups;
word nNumMaterials;
word nNumJoints;

typedef struct
{
word flags;
word vertexIndices[3];
float vertexNormals[3][3];
float s[3];
float t[3];
byte smoothingGroup;
byte groupIndex;
} ms3d_triangle_t;


typedef struct
{
byte flags;
char name[32];
word numtriangles;
word * triangleIndices;
// mu ich im Aufruf deklarieren                                                                                                                                                                
char materialIndex;
} ms3d_group_t;


word temp;  // just a placed, superfluoues



typedef struct
{
char	name[32];
float ambient[4];
float diffuse[4];
float specular[4];
float emissive[4];
float shininess;
float transparency;
char mode;
char texture[128];
char alphamap[128];
} ms3d_material_t;

float fAnimationFPS;
float fCurrentTime;
int iTotalFrames;


typedef struct
{
	float	time;
	float	rotation[3];
} ms3d_keyframe_rot_t;

typedef struct
{
float	time;
float	position[3];
} ms3d_keyframe_pos_t;

typedef struct
{
byte		flags;
char		name[32];
char		parentName[32];
float		rotation[3];
float		position[3];

word numKeyFramesRot;
word numKeyFramesTrans;

ms3d_keyframe_rot_t * keyFramesRot;
ms3d_keyframe_pos_t * keyFramesTrans;

} ms3d_joint_t;



///////////////////////////////// Here begins my part

class MeshInfo
{
private:
	word nNumVertices;
	word nNumTriangles;
	word nNumGroups;
	word nNumMaterials;
	word nNumJoints;

	word garbage;           // placeholder

public:
	MeshInfo();
	~MeshInfo();

	ReadData(char * filename);
	SaveData(char *sourcefile, int gruppe, char *targetfile);	// saves Data in a file
	SaveVertices(char *filename, int gruppe);

	
	int saveCt;
	float *outputArray;
	int *iArray;

	ms3d_header_t		MS_header;			 // MS is for Milkshape
	ms3d_vertex_t		* MS_vertex;         // an array
	ms3d_triangle_t		* MS_triangle;
	ms3d_group_t		* MS_group;			
	ms3d_material_t		* MS_material;
	ms3d_joint_t		* MS_joint;

	ms3d_keyframe_pos_t	MS_keyframePos;
	ms3d_keyframe_rot_t	MS_keyframeRot;

	

	int					nV;	                // number of vertices
	int					nT;					// number of triangles
	int					nG;					// number of groups
	int					nM;					// number of materials
	int					nJ;					// number of Joints;

	float				fAnimationFPS;
	float				fCurrentTime;
	int					iTotalFrames;

} MeshPt;

MeshInfo::MeshInfo()
{
}


MeshInfo::~MeshInfo()
{
}


MeshInfo::ReadData(char * filename)
{
ifstream input(filename, ios::in | ios::binary);
if (input.good() )
	{
	//////////////// Reading in the header
	input.read( (char *) (&MS_header), sizeof( ms3d_header_t ) );
	///////////////// The number of vertices
	word tmp;
	input.read((char *) (&tmp), sizeof(word) );
	nV = int(tmp);

	///////////////// Creating an array for the vertices
	MS_vertex = new ms3d_vertex_t[nV]; 

	////////////////// Reading in vertex data
	for (int i = 0; i < nV; i++)
		{
		input.read( (char *) (&MS_vertex[i]), sizeof(ms3d_vertex_t) );
		}
	///////////////////// Reading in number of Triangles

	input.read((char *) (&nNumTriangles), sizeof(nNumTriangles) );
	nT = int(nNumTriangles);

	MS_triangle = new ms3d_triangle_t[nT];
	
	for (int k = 0; k < nT; k++)
		{
		input.read( (char *) (&MS_triangle[k].flags), sizeof( word ) );
		input.read( (char *) (&MS_triangle[k].vertexIndices[0]), sizeof(word)   );
		input.read( (char *) (&MS_triangle[k].vertexIndices[1]), sizeof(word)   );
		input.read( (char *) (&MS_triangle[k].vertexIndices[2]), sizeof(word)   );
		input.read( (char *) (&MS_triangle[k].vertexNormals[0]), sizeof( float[3][3]  )   );
		input.read( (char *) (&MS_triangle[k].s[0] ), sizeof(float[3] )   );
		input.read( (char *) (&MS_triangle[k].t[0] ), sizeof(float[3] )   );
		input.read( (char *) (&MS_triangle[k].smoothingGroup), sizeof(byte) );
		input.read( (char *) (&MS_triangle[k].groupIndex), sizeof(byte) );
		}

	///////////// now the group data
	input.read((char *) (&nNumGroups), sizeof(nNumGroups) );
	int nG = int(nNumGroups);

	/////////// creating the array
	MS_group = new ms3d_group_t[nG];

	for (int l = 0; l < nG; l++)
		{
		input.read( (char *) (&MS_group[l].flags), sizeof(byte) );
		input.read( (char *) (&MS_group[l].name), sizeof(char[32] ) );
		input.read( (char *) (&MS_group[l].numtriangles), sizeof(word ) );

		//////////////// here is something problematic, not solved yet

		int delta = int(MS_group[l].numtriangles); // Kontrolle, funktioniert
		word *tmp = new word[delta];
		
		for (i = 0; i < delta; i++)
			{
			input.read( (char *) (&tmp[i]), sizeof(word ) );
			// assignment should be
			// MS_group[].triangleIndices = tmp[i];
			// this is not working up to now
			}
		input.read( (&MS_group[l].materialIndex), sizeof(char ) );
		}
	
	
	/// read in material information
	input.read((char *) (&nNumMaterials), sizeof(word) );
	nM = int(nNumMaterials);


	//////////// create an array
	MS_material = new ms3d_material_t[nM];

	for (int m = 0; m < nM; m++)
		{
		input.read( (char *) (&MS_material[m]), sizeof(ms3d_material_t) );
		}

	///////////// read in time aspects
	input.read( (char *) (&fAnimationFPS), sizeof(float  ) );
	input.read( (char *) (&fCurrentTime), sizeof(float  ) );
	input.read( (char *) (&iTotalFrames), sizeof(int  ) );
	///////////////////////////////////

	/////////// read in joint information
	
	input.read((char *) (&nNumJoints), sizeof(word) );
	int nJ = int(nNumJoints);

	///////////////////////////////////////////////////////////
	
	/////////// creating an array

	MS_joint = new ms3d_joint_t[nJ];

	for (int n = 0; n < nJ; n++)
		{
		//input.read( (char *) (&MS_joint[n]), sizeof(ms3d_joint_t) );

		input.read((char *) (&MS_joint[n].flags), sizeof(byte) );
		input.read((char *) (&MS_joint[n].name), sizeof(char[32]) );
		input.read((char *) (&MS_joint[n].parentName), sizeof(char[32]) );
		input.read((char *) (&MS_joint[n].rotation[0]), sizeof(float[3]) );
		input.read((char *) (&MS_joint[n].position[0]), sizeof(float[3]) );
		input.read((char *) (&MS_joint[n].numKeyFramesRot), sizeof(word) );
		input.read((char *) (&MS_joint[n].numKeyFramesTrans), sizeof(word) );

		int nKFR = int(MS_joint[n].numKeyFramesRot);
		int nKFT = int(MS_joint[n].numKeyFramesTrans);
	
		MS_joint[n].keyFramesRot = new ms3d_keyframe_rot_t[nKFR];
		MS_joint[n].keyFramesTrans = new ms3d_keyframe_pos_t[nKFT];

		for (i = 0; i < nKFR; i++)
			{
			input.read((char *) (&MS_joint[n].keyFramesRot[i]), sizeof(ms3d_keyframe_rot_t) );
			}
		
		for (k = 0; k < nKFT; k++)
			{
			input.read((char *) (&garbage), sizeof(ms3d_keyframe_pos_t) );
			}

		}


	}
}



MeshInfo::SaveData(char *sourcefile, int gruppe, char *targetfile)
{
cout << "Das Modell hat vertices  " << nV;
saveCt = 0;

for (int i = 0; i < nV; i ++)
	{
	if ( int(MS_vertex[i].boneID) == gruppe)
		{
		saveCt ++;
		}
	}

iArray = new int[saveCt];
int k = 0;

for (int j = 0; j < nV; j ++)
	{
	if ( int(MS_vertex[j].boneID) == gruppe)
		{
		iArray[k] = j;
		k++;
		}
	}

ofstream ausgabe(targetfile, ios_base::out);
// ofstream ausgabe("shoulder.dat", ios_base::out | ios_base::in | ios_base::ate);
if (ausgabe.good() )
	{
	cout << "Ja 888 scheint zu funktionieren";
	}
else cout << "Probleme mit Output";

for (int m = 0; m < MeshPt.saveCt; m ++)
	{
	ausgabe << MeshPt.iArray[m] << " "; 

	// if you want it to output WDL compatible data, comment the above line out, and take this:

	// fixout << long(MeshPt.iArray[m]);
	
	// (have not tested that) 

	}
}


/////////////////////

MeshInfo::SaveVertices(char *filename, int gruppe)
{
cout << "Das Modell hat vertices  " << nV;
saveCt = 0;

for (int i = 0; i < nV; i ++)
	{
	if ( int(MS_vertex[i].boneID) == gruppe)
		{
		saveCt ++;
		}
	}
outputArray = new float[saveCt*3];

int k = 0;

for (int j = 0; j < nV; j ++)
	{
	if ( int(MS_vertex[j].boneID) == gruppe)
		{
		outputArray[k] = MS_vertex[j].vertex[0];
		outputArray[k+1] = MS_vertex[j].vertex[1];
		outputArray[k+2] = MS_vertex[j].vertex[2];
		k += 3;
		}
	}

}


/////////////////////////
int main()
{
MeshPt.ReadData("Zorro2.ms3d");
MeshPt.SaveData("Zorro2.ms3d", 7, "belly.dat");

cout << "Der SaveCounter steht bei  " << MeshPt.saveCt;

for (int l = 0; l < MeshPt.saveCt; l ++)
	{
	// cout << MeshPt.iArray[l] << "\n";
	}

// cout << "Das ist der Knochen" << int(MeshPt.MS_vertex[500].boneID);

int y;
cin >> y;
return 0;
}



//////////////////////////////////////////////
